#!/bin/bash
set -euo pipefail

#=============================================================================
# Script: 1-install-core.sh  
# PURPOSE: Install minimal required packages
#=============================================================================

echo "📦 RKPi5 v2.1 Core Installation"

sudo apt update -y
sudo apt install -y nginx openssl apache2-utils curl jq dos2unix

sudo mkdir -p /etc/ssl/RKPi5
if [[ ! -f /etc/ssl/RKPi5/certificate.crt ]]; then
sudo openssl req -x509 -nodes -days 3650 -newkey rsa:2048 \
-keyout /etc/ssl/RKPi5/private.key \
-out /etc/ssl/RKPi5/certificate.crt \
-subj "/C=US/ST=CA/L=Training/O=Rapture-Kit/CN=rapturekit.com" \
-addext "subjectAltName=DNS:rapturekit.com,DNS:www.rapturekit.com,IP:10.42.0.1"
sudo chmod 600 /etc/ssl/RKPi5/private.key
sudo chmod 644 /etc/ssl/RKPi5/certificate.crt
echo "✅ SSL created"
else
echo "✅ SSL exists"
fi

sudo mkdir -p /var/www/admin
if [[ ! -f /etc/nginx/.htpasswd ]]; then
sudo htpasswd -bc /etc/nginx/.htpasswd "RKPi5-admin" "Isa1ah46:9-10"
echo "✅ Admin credentials created"
else
echo "✅ Admin credentials present"
fi

echo "✅ Core installation done"
